/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process.diagram;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWDiagramProcessPropertyPanel
extends VWDesignerBasePropertyPanel
implements IVWMapChangedListener,
DocumentListener {
    protected JTextField m_nameTextField;
    protected JTextArea m_descriptionTextArea;

    public VWDiagramProcessPropertyPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        this.setDataObject(null);
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    public Object getDataObject() {
        if (this.m_authPropertyData != null) {
            return this.m_authPropertyData.getWorkflowDefinition();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataObject(Object dataObject) {
        try {
            block5: {
                try {
                    this.m_nameTextField.getDocument().removeDocumentListener(this);
                    this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                    this.m_nameTextField.setText("");
                    this.m_descriptionTextArea.setText("");
                    if (this.m_authPropertyData == null) break block5;
                    VWWorkflowDefinition workflowDefinition = this.m_authPropertyData.getWorkflowDefinition();
                    if (workflowDefinition != null) {
                        this.m_nameTextField.setText(workflowDefinition.getName());
                        this.m_descriptionTextArea.setText(workflowDefinition.getDescription());
                    }
                    this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_5 = null;
                    this.m_nameTextField.getDocument().addDocumentListener(this);
                    this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                }
            }
            Object var4_4 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    public String getDisplayName() {
        return VWResource.s_workflowPropertiesDlgTitle;
    }

    public String getToolTip() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public void displayHelpPage() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh142.htm");
    }

    public void releaseReferences() {
        this.m_nameTextField = null;
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        super.releaseReferences();
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 555: {
                VWWorkflowDefinition workflowDefinition;
                this.m_nameTextField.setText("");
                if (this.m_authPropertyData == null || (workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) == null) break;
                this.m_nameTextField.setText(workflowDefinition.getName());
            }
        }
    }

    public void changedUpdate(DocumentEvent event) {
        if (this.m_authPropertyData == null) {
            return;
        }
        VWWorkflowDefinition workflowDefinition = this.m_authPropertyData.getWorkflowDefinition();
        if (workflowDefinition == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            try {
                workflowDefinition.setName(this.m_nameTextField.getText());
                this.m_authPropertyData.setDirty();
                this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
                this.m_authPropertyData.getMapChangeEventNotifier().notifyMapChange(555);
                this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
            }
            catch (VWException ex) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                this.m_nameTextField.setText(workflowDefinition.getName());
            }
        } else if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
            workflowDefinition.setDescription(this.m_descriptionTextArea.getText());
            this.m_authPropertyData.setDirty();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.getDescriptionPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getNamePanel() {
        try {
            VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWResource.s_workflow);
            JPanel childPanel = stepNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_nameTextField);
            childPanel.add((Component)this.m_nameTextField, "First");
            return stepNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getDescriptionPanel() {
        try {
            VWToolbarBorder descriptionBorder = new VWToolbarBorder(VWResource.s_descriptionStr);
            JPanel childPanel = descriptionBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setName("m_descriptionTextArea_VWDiagramProcessPropertyPanel");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(3);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_descriptionTextArea);
            childPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return descriptionBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

